require "TimedActions/ISBaseTimedAction"

TABAS_CleanTub = ISBaseTimedAction:derive("TABAS_CleanTub")

local function predicateBleach(item)
	return item:getFluidContainer() and item:getFluidContainer():contains(Fluid.Bleach) and (item:getFluidContainer():getAmount() >= ZomboidGlobals.CleanBloodBleachAmount)
end

local function predicateCleaningLiquid(item)
	return item:getFluidContainer() and item:getFluidContainer():contains(Fluid.CleaningLiquid) and (item:getFluidContainer():getAmount() >= ZomboidGlobals.CleanBloodBleachAmount)
end

local function predicateNotBroken(item)
	return not item:isBroken()
end


function TABAS_CleanTub:isValid()
	local playerInv = self.character:getInventory()
	return (playerInv:containsEvalRecurse(predicateBleach) or playerInv:containsEvalRecurse(predicateCleaningLiquid)) and (playerInv:containsTagEval("CleanStains", predicateNotBroken));
end

function TABAS_CleanTub:waitToStart()
    self.character:faceLocation(self.square:getX(), self.square:getY())
	return self.character:shouldBeTurning()
end

function TABAS_CleanTub:update()
    local jobDelta = self:getJobDelta()
    if jobDelta < 0.5  then
        self.character:faceLocation(self.square:getX(), self.square:getY())
    else
        self.character:faceLocation(self.subSquare:getX(), self.subSquare:getY())
    end
    self.character:setMetabolicTarget(Metabolics.LightWork)
end

function TABAS_CleanTub:start()
    local primaryItem = self.character:getPrimaryHandItem()
    self:setActionAnim("ScrubFloor")
    self:setOverrideHandModels(primaryItem, self.cleaner)
    self.sound = self.character:playSound("CleanBloodBleach")

end

function TABAS_CleanTub:stop()
    self.character:stopOrTriggerSound(self.sound)
	ISBaseTimedAction.stop(self)
end

function TABAS_CleanTub.createNewTub(oldObj, sq)
    if not oldObj then return end
    local oldSprite = oldObj:getSpriteName()
    local newSprite
    local isClean = nil
    if oldSprite and oldSprite:find("fixtures_bathroom_01_") then
        if oldSprite:find("tabas_") then
            newSprite = string.gsub(oldSprite, "tabas_", "")
        else
            newSprite = "tabas_" .. oldSprite
            isClean = true
        end
    end
    local newObj = IsoObject.new(getCell(), sq, newSprite)
    if oldObj:hasModData() then
        local modData = oldObj:getModData()
        if type(modData.modData) == "table" then
            for k,v in pairs(modData.modData) do
                newObj:getModData()[k] = v
            end
        end
    end
    newObj:getModData().isClean = isClean
    local overlay = oldObj:getOverlaySprite()
    if overlay then
        newObj:setOverlaySprite(overlay:getName(), true)
    end
    sq:AddTileObject(newObj)
    if isClient() then newObj:transmitCompleteItemToServer() end
    triggerEvent("OnObjectAdded", newObj)
    return newObj
end

function TABAS_CleanTub:complete()
    local cleaner = self.cleaner
    if cleaner then
		cleaner:getFluidContainer():adjustAmount(cleaner:getFluidContainer():getAmount() - ZomboidGlobals.CleanBloodBleachAmount);
    end
    TABAS_CleanTub.createNewTub(self.mainObj, self.square)
    TABAS_CleanTub.createNewTub(self.subObj, self.subSquare)

    if isClient() then
        self.square:transmitRemoveItemFromSquare(self.mainObj)
        self.subSquare:transmitRemoveItemFromSquare(self.subObj)
    end
    if isServer() then
        self.square:transmitRemoveItemFromSquareOnClients(self.mainObj)
        self.subSquare:transmitRemoveItemFromSquareOnClients(self.subObj)
    end
    -- self.subSquare:RemoveTileObject(self.subObj)
    self.square:RemoveTileObject(self.mainObj)
    self.square:RecalcProperties()
    self.square:RecalcAllWithNeighbours(true)
	return true
end

function TABAS_CleanTub:perform()
   self.character:stopOrTriggerSound(self.sound)

	-- needed to remove from queue / start next.
	ISBaseTimedAction.perform(self)
end

function TABAS_CleanTub:getDuration()
    if self.character:isTimedActionInstant() then
        return 1
    end
    return 500
end

function TABAS_CleanTub:new(character, faucetObj, tubObj, cleaner)
    local o = ISBaseTimedAction.new(self, character)
    o.mainObj = faucetObj
    o.subObj = tubObj
    o.square = faucetObj:getSquare()
    o.subSquare = tubObj:getSquare()
    o.cleaner = cleaner
    o.maxTime = o:getDuration()
    o.caloriesModifier = 5
    return o
end